<?php
require_once '../include/security.php';
require '.././libs/Slim/Slim.php';
require '../include/xmlcreator.php';
\Slim\Slim::registerAutoloader();

date_default_timezone_set("Africa/Accra");
$app = new \Slim\Slim();

$xmlObj=new XMLCreator();
// User id from db - Global Variable
$user_id = NULL;

/**
 * Adding Middle Layer to authenticate every request
 * Checking if the request has valid api key in the 'Authorization' header
 */
function authenticate(\Slim\Route $route) {
    // Getting request headers
    $headers = apache_request_headers();
    $response = array();
    $app = \Slim\Slim::getInstance();
     
     if(empty($headers['Authorization']))
         $headers['Authorization']=$app->request->headers->get('Auth');
         
   //print($headers['Authorization']);
    // Verifying Authorization Header
    if (isset($headers['Authorization'])) {
        // get the api key
        $api_key = $headers['Authorization'];
		Security::setUserHeaders($headers);
		//echo $api_key;exit;
        // validating api key
        if (!Security::checkToken($api_key)) {
            // api key is not present in users table
            $response["error"] = true;
            $response["message"] = "Access Denied. Invalid Api key";
            echoRespnse(401, $response);
            $app->stop();
        } else {
            global $user_id;
			$user_id=Security::getUserHash();
            // get user primary key id
        }
    } else {
        // api key is missing in header
        $response["error"] = true;
        $response["message"] = "Api key is misssing";
        echoRespnse(400, $response);
        $app->stop();
    }
}

/*
 * ------------------------ METHODS WITH AUTHENTICATION ------------------------
 */

/**
 * Listing a particular invoice details
 * method GET
 * url /get-invoice          
 */
$app->get('/get-invoice.:id', 'authenticate', function($ext) {
	        
            global $user_id;
			global $db;
			global $app;
			//global $xmlObj;
			$_REQUEST['EXT']=$ext;
            $response = array();
            if(!Security::verifyAction("get-invoice") or $user_id==NULL){
				$response["error"] = true;
				$response["message"] = "Access Denied. UNATHORIZED ACCESS (END-POINT)";
				echoRespnse(401, $response);
				$app->stop();
			}
			verifyRequiredParams(array("invoiceno"));
            // fetching all Invoice Details
            //$result = $db->getInvoiceDetails(HAMSAPI::fineTuneURLInput($_REQUEST['invoiceno']));
			
			//print_r($result);exit;
			$myExt=strtolower($_REQUEST['EXT'])!='json' && strtolower($_REQUEST['EXT'])!='xml'?'json':strtolower($_REQUEST['EXT']);
			 $invoicefile=str_replace("/","-",$_REQUEST['invoiceno']);
			
			$filename="records/".$invoicefile.".".$myExt;
//echo $filename
			$file=file_exists($filename)?@file_get_contents($filename):"";
			
            
			 //$response["BILL"] = array();
			 if($file){
				 
				$response["error"] = false;
				//preparing invoice array
				//$invoiceData=array();
				
					
				 //var_dump($file);exit;
				$response["BILL"]=$file;
				echoRespnse(200, $response);
			 }
			 else
			 {
				 $response["error"] = true;
				$response["message"] = "No invoice found";
				echoRespnse($response["message"], $response);
				$app->stop();
			 }
        });

/**
 * Setting the Bill Payment
 * method POST
 * url /set-payment
 * Will return 401 if access denied
 */
$app->post('/set-payment', 'authenticate', function() {
            global $user_id;
			global $db;
			global $app;
            $response = array();
            if(!Security::verifyAction("set-payment") or $user_id==NULL){
				$response["error"] = true;
				$response["message"] = "Access Denied. UNATHORIZED ACCESS (END-POINT)";
				echoRespnse(401, $response);
				$app->stop();
			}
			verifyRequiredParams(array("InvoiceNo","Number","DateTime","AmountPaid","AmountTendered","Change","Currency","AccountCredited","TellerName"),"POST");
			
			
			
				$xml=NULL;$result=FALSE;
				if(strtotime($_REQUEST['DateTime']) && is_numeric($_REQUEST['AmountPaid']) && is_numeric($_REQUEST['Change'])){
				
					$invoicefile=str_replace("/","-",$_REQUEST['InvoiceNo']);
					
					$filename="records/".$invoicefile.".xml";
					$xml=@file_exists($filename)?simplexml_load_file($filename):NULL;
					
					if($xml){
						$result=$_REQUEST['Number'];
						
						$checkOverUnderPayment=Security::checkOverUnderPayment($xml->Invoice->TotalAmount);
						//print_r($checkOverUnderPayment);
						if($checkOverUnderPayment['error'])
						{
							echoRespnse(401, $checkOverUnderPayment);
							$app->stop();
						}
				      }
				
					
			}
			
			
		$response["payment"]=array();
            if ($result) {
                $response["error"] = false;
				$response['format']='text';
				$response["message"]="Payment was successful {ReceiptNumber:$result}";
				array_push($response["payment"],$result);
                echoRespnse(200, $response);
            } else {
                $response["error"] = true;
                $response["message"] = "Payment was not successful";
                echoRespnse($response["message"], $response);
            }
        });

/**
 * Setting the Cancel Payment
 * method POST
 * url /cancel-payment
 * Will return 401 if access denied
 */
$app->post('/cancel-payment', 'authenticate', function() {
            global $user_id;
			global $db;
			global $app;
            $response = array();
            if(!Security::verifyAction("cancel-payment") or $user_id==NULL){
				$response["error"] = true;
				$response["message"] = "Access Denied. UNATHORIZED ACCESS (END-POINT)";
				echoRespnse(401, $response);
				$app->stop();
			}
			verifyRequiredParams(array("InvoiceNo","Number","PaymentDate","TellerName","ReversalAmt"),"POST");
			
			$xml=NULL;$result=FALSE;
				if(strtotime($_REQUEST['PaymentDate']) && is_numeric($_REQUEST['ReversalAmt'])){
				
					$invoicefile=str_replace("/","-",$_REQUEST['InvoiceNo']);
					
					$filename="records/".$invoicefile.".xml";
					$xml=@file_exists($filename)?simplexml_load_file($filename):NULL;
					
					if($xml){
						$result=$_REQUEST['InvoiceNo'];
				      }
			}
			
		$response["cancelled-payment"]=array();
            if ($result) {
                $response["error"] = false;
				$response['format']='text';
				$response["message"]="Payment Cancellation was successful {InvoiceNumber:$result}";
				array_push($response["cancelled-payment"],$result);
                echoRespnse(200, $response);
            } else {
                $response["error"] = true;
                $response["message"] = "Payment Cancellation was not successful";
                echoRespnse($response["message"], $response);
            }
        });
/**
 * Verifying required params sent or not
 */
function verifyRequiredParams($required_fields ,$httpMethod='GET') {
    $error = false;
    $error_fields = "";
    $request_params = array();
    $request_params = $_POST;
    // Handling request params
	if($_SERVER['REQUEST_METHOD']==$httpMethod && $httpMethod=="GET")
	   $request_params=$_GET;
	else if($_SERVER['REQUEST_METHOD']==$httpMethod && $httpMethod=="POST")
	   $request_params=$_POST;
    else if ($_SERVER['REQUEST_METHOD'] == $httpMethod) {
        $app = \Slim\Slim::getInstance();
        parse_str($app->request()->getBody(), $request_params);
    }
    foreach ($required_fields as $field) {
        if (!isset($request_params[$field]) || strlen(trim($request_params[$field])) <= 0) {
            $error = true;
            $error_fields .= $field . ', ';
        }
    }
    if ($error) {
        // Required field(s) are missing or empty
        // echo error json and stop the app
        $response = array();
        $app = \Slim\Slim::getInstance();
        $response["error"] = true;
        $response["message"] = 'Required field(s) : {' . substr($error_fields, 0, -2) . '} missing or empty';
        echoRespnse(400, $response);
        $app->stop();
    }
}


/**
 * Echoing json response to client
 * @param String $status_code Http response code
 * @param Int $response Json response
 */
function echoRespnse($status_code, $response) {
	global $xmlObj;
    $app = \Slim\Slim::getInstance();
    // Http response code
    $app->status($status_code);
     
	 if($response['error']==true||$response['format']=='text'){
	   Security::logMessage($response['message']);
	   $app->contentType('application/text');
			 
	    print ("error:".(($response['error']==1)?'true':'false').",message:".$response['message']);
	 }
	 else{
		 if($_REQUEST['EXT']=='xml'){
			 
				$app->contentType('application/xml');
				//$xmlObj->OutPutXML();
				echo $response["BILL"];
		 }
		 else{
		   $app->contentType('application/json');
		       
		      echo $response['BILL'];
		 }
	 }
}

$app->run();
?>