<?php

class Security {

    // blowfish
    private static $algo = '$2a';
    // cost parameter
    private static $cost = '$10';
	
	private static $xml=NULL;
	private static $xml_path="secret.rf";
	private static $version="1.6";
	
	private static $UserHash;
	private static $AllowOustandingBill=false;
	
	private static $UserActions=array();
	private static $UserHeaders=array();
    
	public static function setUserHeaders($headers){
		Self::$UserHeaders=$headers;
	}
    // mainly for internal use
    public static function unique_salt() {
        return substr(sha1(mt_rand()), 0, 22);
    }

    // this will be used to generate a hash
    private static function hash($password) {

        return crypt($password, self::$algo .
                self::$cost .
                '$' . self::unique_salt());
    }

    // this will be used to compare a password against a hash
    public static function check_password($hash, $password) {
        $full_salt = substr($hash, 0, 29);
        $new_hash = crypt($password, $full_salt);
        return ($hash == $new_hash);
    }
	
	public static function checkToken($token){
		$hash=Security::hash($token);
		if(Security::check_password($hash,$token) && Security::isTokenExist($token))
		  return true;
		else
		 return false;
	}
	private static function isTokenExist($api_key){
		if(NULL==Security::$xml)
		 $xml= simplexml_load_file(dirname(__FILE__) ."/".Security::$xml_path);
		 	 
		 foreach($xml->ThirdParty as $_thirdParty){
			 if(Self::check_password($_thirdParty->APITOKEN,$api_key) && Security::$version==$_thirdParty->APIVERSION){
				 Security::$UserHash=Security::hash($api_key);
				 foreach($xml->ThirdParty->ACTIONS->ACTION as $action){
					Security::$UserActions[]=$action;
				 }
				self::$AllowOustandingBill=$_thirdParty->ALLOWOUTSTANDING;
			   return true;
			 }
			 else
			   return false;
		 }
	}
	
	public static function getUserHash(){
		return Security::$UserHash;
	}
	public static function getUserActions(){
		return Security::$UserActions;
	}
	
	public static  function verifyAction($Action){
		foreach(Security::$UserActions as $action)
		{
			if($action==$Action)
			return true;
		}
		return false;
	}

//log errors
  private static function getRequestClientDetails(){
	  $str=array();
	  $str["IP"]=$_SERVER['REMOTE_ADDR'];
	 
	  foreach($_REQUEST as $key=>$value){
		  if(!$value) $value='';
	    $str['Params'].="$key = ".$value.",";
	  }
		
		$str['Params']=trim($str['Params'],',');
		
	  $str["Browser"]=$_SERVER['HTTP_USER_AGENT'];
	  $str["Referrer"]=$_SERVER['HTTP_REFERER'];
	  
	  foreach(Self::$UserHeaders as $key=>$value){
		  if(!$value) $value='';
	    $str['Headers'].="$key = ".$value.",";
	  }
		$str['Headers']=trim($str['Headers'],',');
	  
	  $final=NULL;
	  foreach($str as $key=>$value){
		   if(!$value) $value='';
	   $final.="$key => ".$value."||";
	  }
	  
	  $final=trim($final,"||");
	  return $final;
  }
   public static function logMessage($message){
	   date_default_timezone_set('Africa/Accra');
	   $filename="../logs/".date('Y-m-d').".lg";
	   $fd=NULL;$theOldData=NULL;
	   if(!file_exists($filename))
	   $fd = fopen($filename, 'w') or die("Can't create file");
	   else
	   $fd = fopen($filename, "a+");
	   $theOldData = @fread($fd, filesize($filename));
	   @fclose($fd);
	  
	   $fd = fopen($filename, 'w+') or die("can't open file");
	   // append date/time to message
	   $str = "*[" . date("h:i:s A", mktime()) . "] " . $message;
	   $str.=" : {";
	   
	   $details=self::getRequestClientDetails();
	   $str.=$details."}\n";
	   $str=trim($str);
	   $strlen=strlen($str);
	   
	   $str.="\n";
	   for($i=0;$i<$strlen;$i++)
	     $str=$str."=";
	   // write string
	   fwrite($fd, $str."\n".$theOldData . "\n");
	 
	   // close file
	   fclose($fd); 
	  
   }
   
   public static function checkOverUnderPayment($invoiceAmt){
	  
	   //$invoiceAmt= $db->getInvoiceAmt($_REQUEST['InvoiceNo']);
	   
	  $allowOutstanding=(self::$AllowOustandingBill=='TRUE')?true:false;
	 
	   $amtPaid=$_REQUEST['AmountPaid'];
	   
	   $response["error"]=false;
	   if(!is_numeric($_REQUEST['AmountPaid']))
	   {
		   $response["error"] = true;
                $response["message"] = "Payment amount should be numeric";
	   }
	   else if($amtPaid<$invoiceAmt and $allowOutstanding==FALSE)
	   {
		   $response["error"] = true;
                $response["message"] = "Payment amount cannot be less than the invoice amount";
	   }
	 
	   return $response;
   }
}
//echo Security::hash("Uzb4ToNBZN");
/*
To help generate new apitoken
echo Security::hash("Uzb4ToNBZN");*/
#echo Security::check_password('$2a$10$a639c56ca3d1bd4fe0e16uO1bTnk1QNaIDoLeAipEteTcpyrYyyEq','Sam');
?>
